#! /bin/sh
#
# BeAIM 1.5 Installer
# Get BeAIM at:
# http://www.fifthace.com/beaim/
#

base=`dirname "$0"`

alert --info "Welcome to the BeAIM Installer! Do you want to continue installing BeAIM 1.5?" "Cancel" "Install" > /dev/null
if [ $? -eq 0 ]
then
	exit 0
fi

alert --info "The BeAIM program files and sound files will now be copied to their correct locations."

# make some directories
mkdir /boot/beos/apps/BeAIM
mkdir /boot/beos/apps/BeAIM/Languages
mkdir /boot/home/config/sounds/BeAIM

cp "$base/Install Files/BeAIM" /boot/beos/apps/BeAIM/
cp "$base/Install Files/1.5 README" /boot/beos/apps/BeAIM/
cp "$base/Install Files/Credits.txt" /boot/beos/apps/BeAIM/
cp "$base/Install Files/In case of crashes..." /boot/beos/apps/BeAIM/
cp "$base/Install Files/Languages/English" /boot/beos/apps/BeAIM/Languages
cp "$base/Install Files/Languages/Les français" /boot/beos/apps/BeAIM/Languages
cp "$base/Install Files/BeAIM_IdleTime_Filter.so" /boot/home/config/add-ons/input_server/

cp "$base/Install Files/Sounds/AIMDrip" /boot/home/config/sounds/BeAIM
cp "$base/Install Files/Sounds/AIMEnter" /boot/home/config/sounds/BeAIM
cp "$base/Install Files/Sounds/AIMExit" /boot/home/config/sounds/BeAIM
cp "$base/Install Files/Sounds/AIMGotWarned" /boot/home/config/sounds/BeAIM
cp "$base/Install Files/Sounds/AIMNewMessage" /boot/home/config/sounds/BeAIM
cp "$base/Install Files/Sounds/AIMReceive" /boot/home/config/sounds/BeAIM
cp "$base/Install Files/Sounds/AIMSend" /boot/home/config/sounds/BeAIM

ln -s /boot/beos/apps/BeAIM/BeAIM /boot/apps/BeAIM

alert --idea "Would you like to put a link to BeAIM in your applications menu?" "No" "Yes" > /dev/null
if [ $? -eq 1 ]
then
	ln -s /boot/beos/apps/BeAIM/BeAIM /boot/home/config/be/Applications/BeAIM > /dev/NULL
fi

alert --idea "Would you like to put a link to BeAIM on your desktop?" "No" "Yes" > /dev/null
if [ $? -eq 1 ]
then
	ln -s /boot/beos/apps/BeAIM/BeAIM /boot/home/Desktop/BeAIM > /dev/NULL
fi

alert --info "The input_server will now be restarted - your mouse and keyboard might not work for a second or two."
/system/servers/input_server -q

alert --info "BeAIM 1.5 is now installed!"
